"use client";

import {
  Box,
  Card,
  Text,
  Group,
  SimpleGrid,
  Select,
  Stack,
  Flex,
  Avatar,
  Divider,
  Grid,
  Tabs,
  Button,
  Paper,
  ActionIcon,
} from "@mantine/core";
import {
  IconBuilding,
  IconList,
  IconCalendar,
  IconChevronLeft,
  IconPhone,
  IconMessage,
  IconMoodHappy,
} from "@tabler/icons-react";
import { DonutChart, BarChart } from "@mantine/charts";
import theme from "../../../styles/theme";

const stats = [
  {
    title: "178",
    description: "عدد المساكن",
    icon: IconBuilding,
    color: theme.colors.gold,
  },
  {
    title: "178",
    description: "عدد الطلبات",
    icon: IconList,
    color: theme.colors.purple,
  },
  {
    title: "178",
    description: "عدد الحجوزات",
    icon: IconCalendar,
    color: theme.colors.navy,
  },
];

const months = [
  { value: "1", label: "يناير" },
  { value: "2", label: "فبراير" },
  { value: "3", label: "مارس" },
  { value: "4", label: "أبريل" },
  { value: "5", label: "مايو" },
  { value: "6", label: "يونيو" },
  { value: "7", label: "يوليو" },
  { value: "8", label: "أغسطس" },
  { value: "9", label: "سبتمبر" },
  { value: "10", label: "أكتوبر" },
  { value: "11", label: "نوفمبر" },
  { value: "12", label: "ديسمبر" },
];

const bookingsData = [
  { name: "مغادرة", value: 300, color: "#4CAF50" },
  { name: "وصول", value: 400, color: "#2196F3" },
  { name: "يقطن حاليا", value: 200, color: "#FF9800" },
];

const requestsData = [
  { name: "جديد", value: 250, color: theme.colors.gold },
  { name: "قيد المراجعة", value: 300, color: theme.colors.purple },
  { name: "تم القبول", value: 200, color: theme.colors.navy },
  { name: "مرفوض", value: 100, color: "#FF6B6B" },
];

const RatingCard = ({
  rating,
  category,
}: {
  rating: string;
  category: string;
}) => (
  <Paper
    p="xl"
    radius="md"
    style={{
      backgroundColor: "transparent",
      border: `1px solid ${theme.colors.gold}`,
      textAlign: "center",
    }}
  >
    <Text size="xl" fw={700} mb="xs">
      {rating.split("/")[0]}
      <Text span c={theme.colors.gold}>
        /{rating.split("/")[1]}
      </Text>
    </Text>
    <Text size="md" fw={500}>
      {category}
    </Text>
  </Paper>
);

// Review Item Component
const ReviewItem = ({ name, comment }: { name: string; comment: string }) => (
  <Group justify="space-between" align="center">
    <Text size="sm" fw={500}>
      {name}
    </Text>
    <Group gap="xs">
      <Text size="sm" c="dimmed">
        {comment}
      </Text>
      <IconMoodHappy size={20} color="#1ABC9C" />
    </Group>
  </Group>
);

// Latest Ratings Section Component
const LatestRatings = () => {
  const ratings = [
    { rating: "10/5", category: "النظافة" },
    { rating: "9/5", category: "الخدمة" },
    { rating: "8/5", category: "الموقع" },
    { rating: "10/5", category: "الراحة" },
  ];

  const reviews = [
    { name: "خالد محمد", comment: "مكان مريح وجميل ونظيف" },
    { name: "أحمد علي", comment: "خدمة ممتازة وموظفين متعاونين" },
    { name: "محمد سعيد", comment: "موقع استراتيجي وهادئ" },
    { name: "سارة أحمد", comment: "إقامة مريحة وهادئة" },
  ];

  return (
    <Card padding="lg" radius="md" shadow="xs">
      <Group justify="space-between" mb="xl">
        <Text fw={700} size="md" c={theme.colors.darkGray}>
          آخر التقييمات
        </Text>
        <Text
          size="sm"
          fw={700}
          c={theme.colors.black}
          style={{ cursor: "pointer" }}
        >
          عرض الكل
        </Text>
      </Group>

      <SimpleGrid cols={{ base: 1, sm: 2, md: 4 }} spacing="lg">
        {ratings.map((rating, index) => (
          <RatingCard
            key={index}
            rating={rating.rating}
            category={rating.category}
          />
        ))}
      </SimpleGrid>

      <Stack mt="xl" gap="md">
        {reviews.map((review, index) => (
          <ReviewItem key={index} name={review.name} comment={review.comment} />
        ))}
      </Stack>
    </Card>
  );
};

export default function Dashboard() {
  return (
    <Box p="xl">
      <SimpleGrid cols={{ base: 1, sm: 2, md: 3 }} spacing="lg" mb="xl">
        {stats.map((stat, index) => {
          const Icon = stat.icon;
          return (
            <Card
              key={index}
              padding="lg"
              radius="md"
              shadow="xs"
              style={{
                backgroundColor: "white",
                transition: "transform 0.2s ease",
                "&:hover": {
                  transform: "translateY(-5px)",
                },
              }}
            >
              <Group>
                <Box
                  style={{
                    backgroundColor: `${stat.color}15`,
                    padding: "12px",
                    borderRadius: "12px",
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center",
                  }}
                >
                  <Icon size={24} color={stat.color} />
                </Box>
                <Box>
                  <Text fw={700} size="xl" c="black">
                    {stat.title}
                  </Text>
                  <Text size="sm" c="dimmed">
                    {stat.description}
                  </Text>
                </Box>
              </Group>
            </Card>
          );
        })}
      </SimpleGrid>

      <SimpleGrid cols={{ base: 1, md: 2 }} spacing="lg">
        {/* Bookings Card */}
        <Card padding="lg" radius="md" shadow="xs">
          <Group justify="space-between" mb="md">
            <Text fw={600} size="md" c={theme.colors.darkGray}>
              الحجوزات
            </Text>
            <Select data={months} defaultValue="1" style={{ width: 120 }} />
          </Group>
          <Flex
            justify="center"
            align="center"
            style={{ position: "relative", height: 300 }}
          >
            <Box style={{ position: "relative" }}>
              <Stack
                style={{
                  position: "absolute",
                  left: -150,
                  top: "50%",
                  transform: "translateY(-50%)",
                }}
              >
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: "#4CAF50",
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    مغادرة
                  </Text>
                </Group>
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: "#2196F3",
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    وصول
                  </Text>
                </Group>
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: "#FF9800",
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    يقطن حاليا
                  </Text>
                </Group>
              </Stack>
              <DonutChart
                data={bookingsData}
                size={250}
                thickness={30}
                paddingAngle={2}
                withTooltip
                tooltipDataSource="segment"
              />
              <Box
                style={{
                  position: "absolute",
                  top: "50%",
                  left: "50%",
                  transform: "translate(-50%, -50%)",
                  textAlign: "center",
                }}
              >
                <Text c={theme.colors.labelChart} size="sm" fw={600} mb={5}>
                  عدد الحجوزات
                </Text>
                <Text c={theme.colors.labelChart2} size="xl" fw={700}>
                  999
                </Text>
              </Box>
            </Box>
          </Flex>
        </Card>

        {/* Requests Card */}
        <Card padding="lg" radius="md" shadow="xs">
          <Group justify="space-between" mb="md">
            <Text fw={700} size="md" c={theme.colors.darkGray}>
              الطلبات
            </Text>
            <Select data={months} defaultValue="1" style={{ width: 120 }} />
          </Group>
          <Flex
            justify="center"
            align="center"
            style={{ position: "relative", height: 300 }}
          >
            <Box style={{ position: "relative" }}>
              <Stack
                style={{
                  position: "absolute",
                  left: -150,
                  top: "50%",
                  transform: "translateY(-50%)",
                }}
              >
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: theme.colors.gold,
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    جديد
                  </Text>
                </Group>
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: theme.colors.purple,
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    قيد المراجعة
                  </Text>
                </Group>
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: theme.colors.navy,
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    تم القبول
                  </Text>
                </Group>
                <Group gap="xs">
                  <Box
                    style={{
                      width: 12,
                      height: 12,
                      borderRadius: "20%",
                      backgroundColor: "#FF6B6B",
                    }}
                  />
                  <Text size="sm" c="dimmed">
                    مرفوض
                  </Text>
                </Group>
              </Stack>
              <DonutChart
                data={requestsData}
                size={250}
                thickness={30}
                paddingAngle={2}
                withTooltip
                tooltipDataSource="segment"
              />
              <Box
                style={{
                  position: "absolute",
                  top: "50%",
                  left: "50%",
                  transform: "translate(-50%, -50%)",
                  textAlign: "center",
                }}
              >
                <Text c={theme.colors.labelChart} size="sm" fw={600} mb={5}>
                  عدد الطلبات
                </Text>
                <Text c={theme.colors.labelChart2} size="xl" fw={700}>
                  999
                </Text>
              </Box>
            </Box>
          </Flex>
        </Card>
      </SimpleGrid>

      <Grid mt="xl">
        <Grid.Col span={{ base: 12, md: 8 }}>
          {/* Bookings Chart Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Group justify="space-between" mb="md">
              <Text fw={700} size="md" c={theme.colors.darkGray}>
                عدد الحجوزات
              </Text>
              <Select
                data={[
                  { value: "daily", label: "يومي" },
                  { value: "monthly", label: "شهري" },
                  { value: "yearly", label: "سنوي" },
                ]}
                defaultValue="monthly"
                style={{ width: 120 }}
              />
            </Group>
            <BarChart
              h={300}
              data={[
                { month: "يناير", value: 4 },
                { month: "فبراير", value: 7 },
                { month: "مارس", value: 3 },
                { month: "أبريل", value: 9 },
                { month: "مايو", value: 5 },
                { month: "يونيو", value: 8 },
                { month: "يوليو", value: 2 },
                { month: "أغسطس", value: 6 },
                { month: "سبتمبر", value: 4 },
                { month: "أكتوبر", value: 7 },
                { month: "نوفمبر", value: 3 },
                { month: "ديسمبر", value: 5 },
              ]}
              dataKey="month"
              series={[{ name: "value", color: theme.colors.gold }]}
              tickLine="y"
              gridAxis="xy"
              yAxisProps={{ domain: [0, 11] }}
            />
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12, md: 4 }}>
          {/* Notifications Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Text fw={700} size="md" c={theme.colors.darkGray} mb="xl">
              آخر الإشعارات
            </Text>

            <Stack gap="lg">
              <Group>
                <Avatar src="/placeholder-avatar.jpg" radius="xl" size="md" />
                <Box>
                  <Text size="sm" fw={500}>
                    قام خالد محمد بطلب ايجار سكن
                  </Text>
                  <Text size="xs" c="dimmed">
                    منذ خمس دقائق
                  </Text>
                </Box>
              </Group>

              <Divider />

              <Group>
                <Avatar src="/placeholder-avatar.jpg" radius="xl" size="md" />
                <Box>
                  <Text size="sm" fw={500}>
                    قام خالد محمد بطلب ايجار سكن
                  </Text>
                  <Text size="xs" c="dimmed">
                    منذ خمس دقائق
                  </Text>
                </Box>
              </Group>

              <Divider />

              <Group justify="center" mt="md">
                <Text size="sm" c="dimmed" style={{ cursor: "pointer" }}>
                  عرض الكل
                </Text>
                <IconChevronLeft size={16} color={theme.colors.darkGray} />
              </Group>
            </Stack>
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12 }}>
          {/* Booking Summary Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Group justify="space-between" mb="xl">
              <Text fw={700} size="md" c={theme.colors.darkGray}>
                ملخص الحجوزات
              </Text>
              <Text
                size="sm"
                fw={700}
                c={theme.colors.black}
                style={{ cursor: "pointer" }}
              >
                عرض الكل
              </Text>
            </Group>

            <SimpleGrid cols={{ base: 1, sm: 3 }} mb="xl">
              {[
                { title: "الحجوزات", value: "178" },
                { title: "الوافدون", value: "45" },
                { title: "المغادرون", value: "23" },
              ].map((stat, index) => (
                <Paper
                  key={index}
                  p="md"
                  radius="md"
                  style={{
                    backgroundColor: theme.colors.gold,
                    textAlign: "center",
                  }}
                >
                  <Text size="lg" fw={700} c="white">
                    {stat.title}
                  </Text>
                  <Text size="xl" fw={700} c="white">
                    {stat.value}
                  </Text>
                </Paper>
              ))}
            </SimpleGrid>

            <Tabs
              defaultValue="all"
              variant="pills"
              styles={{
                tab: {
                  "&[dataActive]": {
                    backgroundColor: theme.colors.darkGray,
                    color: theme.colors.white,
                  },
                },
              }}
            >
              <Tabs.List>
                <Tabs.Tab value="all">الكل</Tabs.Tab>
                <Tabs.Tab value="current">يقطن حاليا</Tabs.Tab>
                <Tabs.Tab value="arrival">وصول</Tabs.Tab>
                <Tabs.Tab value="departure">مغادرة</Tabs.Tab>
              </Tabs.List>

              <Tabs.Panel value="all" pt="xl">
                <SimpleGrid cols={{ base: 1, sm: 2, md: 4 }} spacing="lg">
                  {[1, 2, 3, 4].map((_, index) => (
                    <Card key={index} padding="lg" radius="md" shadow="xs">
                      <Group justify="space-between" mb="md">
                        <Group>
                          <Box
                            style={{
                              width: 32,
                              height: 32,
                              borderRadius: "50%",
                              backgroundColor: "#1ABC9C",
                              display: "flex",
                              alignItems: "center",
                              justifyContent: "center",
                            }}
                          >
                            <Text size="sm" fw={700} c="white">
                              {index + 1}
                            </Text>
                          </Box>
                          <Text size="sm" fw={500}>
                            رقم الحجز
                          </Text>
                        </Group>
                        <Paper
                          px="md"
                          py="xs"
                          radius={13}
                          style={{ backgroundColor: "#CFC07B" }}
                        >
                          <Text size="xs" c="white">
                            يقطن حاليا
                          </Text>
                        </Paper>
                      </Group>

                      <Text c={theme.colors.gold} size="sm" fw={500} mb="md">
                        معلومات الحجز
                      </Text>

                      <Stack gap="xs" mb="md">
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            اسم السكن
                          </Text>
                          <Text size="sm" fw={500}>
                            4 ليالي
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            اسم السكن
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            عدد الليالي
                          </Text>
                        </Group>
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            2 يناير 2024
                          </Text>
                          <Text size="sm" fw={500} c={theme.colors.black}>
                            4 يناير 2024
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            تاريخ الدخول
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            تاريخ الخروج
                          </Text>
                        </Group>
                      </Stack>

                      <Text c={theme.colors.gold} size="sm" fw={500} mb="xs">
                        المقيم
                      </Text>

                      <Stack gap="xs" mb="md">
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            خالد محمد
                          </Text>
                          <Text size="sm" fw={500}>
                            طلب صيانة
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            اسم المقيم
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            الطلبات
                          </Text>
                        </Group>
                      </Stack>

                      <Group justify="center" mb="md">
                        <Group gap="xs" p="xs">
                          <ActionIcon
                            style={{
                              borderRadius: 17.006,
                              backgroundColor: "#F1EDF9",
                            }}
                          >
                            <IconPhone
                              size={20}
                              color={theme.colors.darkGray}
                            />
                          </ActionIcon>

                          <ActionIcon
                            style={{
                              borderRadius: 17.006,
                              backgroundColor: "#F1EDF9",
                            }}
                          >
                            <IconMessage
                              size={20}
                              color={theme.colors.darkGray}
                            />
                          </ActionIcon>
                        </Group>
                      </Group>

                      <Button
                        fullWidth
                        style={{
                          backgroundColor: theme.colors.gold,
                          color: "white",
                        }}
                      >
                        عرض التفاصيل
                      </Button>
                    </Card>
                  ))}
                </SimpleGrid>
              </Tabs.Panel>
            </Tabs>
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12 }}>
          {/* Latest Requests Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Group justify="space-between" mb="xl">
              <Text fw={700} size="md" c={theme.colors.darkGray}>
                آخر الطلبات
              </Text>
              <Text
                size="sm"
                fw={700}
                c={theme.colors.black}
                style={{ cursor: "pointer" }}
              >
                عرض الكل
              </Text>
            </Group>

            <Paper
              p="md"
              radius="md"
              mb="xl"
              style={{
                backgroundColor: theme.colors.gold,
                textAlign: "start",
              }}
            >
              <Text size="lg" fw={700} c="white">
                الطلبات
              </Text>
              <Text size="xl" fw={700} c="white">
                178
              </Text>
            </Paper>

            <Tabs
              defaultValue="all"
              variant="pills"
              styles={{
                tab: {
                  "&[dataActive]": {
                    backgroundColor: theme.colors.darkGray,
                    color: theme.colors.white,
                  },
                },
              }}
            >
              <Tabs.List>
                <Tabs.Tab value="all">الكل</Tabs.Tab>
                <Tabs.Tab value="current">دخول مبكر</Tabs.Tab>
                <Tabs.Tab value="arrival">خروج مبكر</Tabs.Tab>
                <Tabs.Tab value="departure">نظافة</Tabs.Tab>
                <Tabs.Tab value="departure">صيانة</Tabs.Tab>
                <Tabs.Tab value="departure">اخرى</Tabs.Tab>
              </Tabs.List>

              <Tabs.Panel value="all" pt="xl">
                <SimpleGrid cols={{ base: 1, sm: 2, md: 4 }} spacing="lg">
                  {[1, 2, 3, 4].map((_, index) => (
                    <Card key={index} padding="lg" radius="md" shadow="xs">
                      <Group justify="space-between" mb="md">
                        <Group>
                          <Box
                            style={{
                              width: 32,
                              height: 32,
                              borderRadius: "50%",
                              backgroundColor: "#1ABC9C",
                              display: "flex",
                              alignItems: "center",
                              justifyContent: "center",
                            }}
                          >
                            <Text size="sm" fw={700} c="white">
                              {index + 1}
                            </Text>
                          </Box>
                          <Text size="sm" fw={500}>
                            رقم الحجز
                          </Text>
                        </Group>
                      </Group>

                      <Text c={theme.colors.gold} size="sm" fw={500} mb="md">
                        معلومات الحجز
                      </Text>

                      <Stack gap="xs" mb="md">
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            اسم السكن
                          </Text>
                          <Text size="sm" fw={500} c={theme.colors.black}>
                            4 ليالي
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            اسم السكن
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            عدد الليالي
                          </Text>
                        </Group>
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            2 يناير 2024
                          </Text>
                          <Text size="sm" fw={500} c={theme.colors.black}>
                            4 يناير 2024
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            تاريخ الدخول
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            تاريخ الخروج
                          </Text>
                        </Group>
                      </Stack>

                      <Text c={theme.colors.gold} size="sm" fw={500} mb="xs">
                        المقيم
                      </Text>

                      <Stack gap="xs" mb="md">
                        <Group>
                          <Text size="sm" c={theme.colors.black}>
                            خالد محمد
                          </Text>
                          <Text size="sm" fw={500} c={theme.colors.black}>
                            طلب صيانة
                          </Text>
                        </Group>
                        <Group mb="md">
                          <Text size="xs" c={theme.colors.darkGray}>
                            اسم المقيم
                          </Text>
                          <Text size="xs" fw={500} c={theme.colors.darkGray}>
                            الطلبات
                          </Text>
                        </Group>
                      </Stack>

                      <Group grow mb="md">
                        <Button
                          style={{
                            backgroundColor: "#8C8082",
                            color: "white",
                          }}
                        >
                          موافق
                        </Button>
                        <Button
                          style={{
                            backgroundColor: "#E60F0F",
                            color: "white",
                          }}
                        >
                          غير موافق
                        </Button>
                      </Group>

                      <Button
                        fullWidth
                        mb="md"
                        style={{
                          backgroundColor: theme.colors.gold,
                          color: "white",
                        }}
                      >
                        عرض التفاصيل
                      </Button>

                      <Group justify="center">
                        <Group gap="xs">
                          <ActionIcon
                            style={{
                              borderRadius: 17.006,
                              backgroundColor: "#F1EDF9",
                            }}
                          >
                            <IconPhone
                              size={20}
                              color={theme.colors.darkGray}
                            />
                          </ActionIcon>

                          <ActionIcon
                            style={{
                              borderRadius: 17.006,
                              backgroundColor: "#F1EDF9",
                            }}
                          >
                            <IconMessage
                              size={20}
                              color={theme.colors.darkGray}
                            />
                          </ActionIcon>
                        </Group>
                      </Group>
                    </Card>
                  ))}
                </SimpleGrid>

                <Group grow mt="xl">
                  <Button
                    size="lg"
                    style={{
                      borderRadius: "30px",
                      backgroundColor: "#F5F5F5",
                      color: theme.colors.darkGray,
                    }}
                  >
                    استفسار
                  </Button>
                  <Button
                    size="lg"
                    style={{
                      borderRadius: "30px",
                      backgroundColor: "#F5F5F5",
                      color: theme.colors.darkGray,
                    }}
                  >
                    شكوى
                  </Button>
                </Group>
              </Tabs.Panel>
            </Tabs>
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12 }}>
          {/* Financial Transfers Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Group justify="space-between" mb="xl">
              <Text fw={700} size="md" c={theme.colors.darkGray}>
                التحويلات المالية
              </Text>
              <Text
                size="sm"
                fw={700}
                c={theme.colors.black}
                style={{ cursor: "pointer" }}
              >
                عرض الكل
              </Text>
            </Group>

            <Tabs
              defaultValue="all"
              variant="pills"
              styles={{
                tab: {
                  "&[dataActive]": {
                    backgroundColor: theme.colors.darkGray,
                    color: theme.colors.white,
                  },
                },
              }}
            >
              <Tabs.List>
                <Tabs.Tab value="all">الكل</Tabs.Tab>
                <Tabs.Tab value="pending">قيد التحويل</Tabs.Tab>
                <Tabs.Tab value="completed">تم التحويل</Tabs.Tab>
              </Tabs.List>

              <Tabs.Panel value="all" pt="xl">
                <SimpleGrid cols={{ base: 1, sm: 2, md: 4 }} spacing="lg">
                  {[
                    {
                      id: "||",
                      amount: "300",
                      date: "12 يناير 2024",
                      status: "تم التحويل",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      amount: "450",
                      date: "11 يناير 2024",
                      status: "تم التحويل",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      amount: "200",
                      date: "10 يناير 2024",
                      status: "تم التحويل",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      amount: "600",
                      date: "9 يناير 2024",
                      status: "تم التحويل",
                      statusColor: theme.colors.darkGray,
                    },
                  ].map((transfer, index) => (
                    <Card key={index} padding="lg" radius="md" shadow="md">
                      <Group mb="md">
                        <Box
                          style={{
                            width: 32,
                            height: 32,
                            borderRadius: "50%",
                            backgroundColor: theme.colors.gold,
                            display: "flex",
                            alignItems: "center",
                            justifyContent: "center",
                          }}
                        >
                          <Text size="sm" fw={700} c={theme.colors.white}>
                            {transfer.id}
                          </Text>
                        </Box>
                        <Text c={theme.colors.darkGray} size="sm" fw={500}>
                          رقم العملية
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between" mb="md">
                        <Text size="sm" c={theme.colors.darkGray}>
                          المبلغ
                        </Text>
                        <Text size="sm" fw={500}>
                          {transfer.amount}
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between" mb="md">
                        <Text size="sm" c={theme.colors.darkGray}>
                          تاريخ العملية
                        </Text>
                        <Text size="sm" fw={500}>
                          {transfer.date}
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between">
                        <Text size="sm" c={theme.colors.darkGray}>
                          حالة العملية
                        </Text>
                        <Paper
                          px="md"
                          py="xs"
                          radius={40}
                          style={{ backgroundColor: transfer.statusColor }}
                        >
                          <Text size="xs" c="white">
                            {transfer.status}
                          </Text>
                        </Paper>
                      </Group>
                    </Card>
                  ))}
                </SimpleGrid>
              </Tabs.Panel>
            </Tabs>
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12 }}>
          {/* Latest Complaints Card */}
          <Card padding="lg" radius="md" shadow="xs">
            <Group justify="space-between" mb="xl">
              <Text fw={700} size="md" c={theme.colors.darkGray}>
                آخر الشكاوى
              </Text>
              <Text
                size="sm"
                fw={700}
                c={theme.colors.black}
                style={{ cursor: "pointer" }}
              >
                عرض الكل
              </Text>
            </Group>

            <Tabs
              defaultValue="all"
              variant="pills"
              styles={{
                tab: {
                  "&[dataActive]": {
                    backgroundColor: theme.colors.darkGray,
                    color: theme.colors.white,
                  },
                },
              }}
            >
              <Tabs.List>
                <Tabs.Tab value="all">الكل</Tabs.Tab>
                <Tabs.Tab value="pending">قيد المراجعة</Tabs.Tab>
                <Tabs.Tab value="completed">تم الرد</Tabs.Tab>
              </Tabs.List>

              <Tabs.Panel value="all" pt="xl">
                <SimpleGrid cols={{ base: 1, sm: 2, md: 4 }} spacing="lg">
                  {[
                    {
                      id: "||",
                      title: "مشكلة في التكييف",
                      date: "12 يناير 2024",
                      status: "تم الرد",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      title: "مشكلة في النظافة",
                      date: "11 يناير 2024",
                      status: "قيد المراجعة",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      title: "مشكلة في الكهرباء",
                      date: "10 يناير 2024",
                      status: "تم الرد",
                      statusColor: theme.colors.darkGray,
                    },
                    {
                      id: "||",
                      title: "مشكلة في المياه",
                      date: "9 يناير 2024",
                      status: "قيد المراجعة",
                      statusColor: theme.colors.darkGray,
                    },
                  ].map((complaint, index) => (
                    <Card key={index} padding="lg" radius="md" shadow="md">
                      <Group mb="md">
                        <Box
                          style={{
                            width: 32,
                            height: 32,
                            borderRadius: "50%",
                            backgroundColor: theme.colors.gold,
                            display: "flex",
                            alignItems: "center",
                            justifyContent: "center",
                          }}
                        >
                          <Text size="sm" fw={700} c={theme.colors.white}>
                            {complaint.id}
                          </Text>
                        </Box>
                        <Text c={theme.colors.darkGray} size="sm" fw={500}>
                          رقم الشكوى
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between" mb="md">
                        <Text size="sm" c={theme.colors.darkGray}>
                          عنوان الشكوى
                        </Text>
                        <Text size="sm" fw={500}>
                          {complaint.title}
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between" mb="md">
                        <Text size="sm" c={theme.colors.darkGray}>
                          تاريخ الشكوى
                        </Text>
                        <Text size="sm" fw={500}>
                          {complaint.date}
                        </Text>
                      </Group>

                      <Divider mb="md" />

                      <Group justify="space-between">
                        <Text size="sm" c={theme.colors.darkGray}>
                          حالة الشكوى
                        </Text>
                        <Paper
                          px="md"
                          py="xs"
                          radius={40}
                          style={{ backgroundColor: complaint.statusColor }}
                        >
                          <Text size="xs" c="white">
                            {complaint.status}
                          </Text>
                        </Paper>
                      </Group>
                    </Card>
                  ))}
                </SimpleGrid>

                <Group grow mt="xl">
                  <Button
                    size="xl"
                    style={{
                      borderRadius: "30px",
                      backgroundColor: "#F5F5F5",
                      color: theme.colors.darkGray,
                    }}
                  >
                    استفسار
                  </Button>
                  <Button
                    size="xl"
                    style={{
                      borderRadius: "30px",
                      backgroundColor: "#F5F5F5",
                      color: theme.colors.darkGray,
                    }}
                  >
                    شكوى
                  </Button>
                </Group>
              </Tabs.Panel>
            </Tabs>
          </Card>
        </Grid.Col>

        <Grid.Col span={{ base: 12 }}>
          <LatestRatings />
        </Grid.Col>
      </Grid>
    </Box>
  );
}
