import { TextInput } from "@mantine/core";
import theme from "@/styles/theme";
import { ReactNode } from "react";

const inputStyles = {
  input: {
    borderRadius: 6,
    background: theme.colors.white,
    height: 50,
    "&:focus": {
      border: `1px solid ${theme.colors.gold}`,
    },
  },
  label: {
    marginBottom: "5px",
    color: "#64748B",
    fontSize: "18px",
    fontWeight: 700,
  },
};

interface InputFieldProps {
  label: string;
  placeholder: string;
  rightSection?: ReactNode;
  [key: string]: any;
}

export default function CustomInput({
  label,
  placeholder,
  rightSection,
  ...props
}: InputFieldProps) {
  return (
    <TextInput
      label={label}
      placeholder={placeholder}
      size="lg"
      mt="md"
      rightSection={rightSection}
      styles={inputStyles}
      {...props}
    />
  );
}
