import { Select } from "@mantine/core";
import theme from "@/styles/theme";
import { IconChevronDown } from "@tabler/icons-react";

const inputStyles = {
  input: {
    borderRadius: 6,
    background: theme.colors.white,
    height: 50,
    "&:focus": {
      border: `1px solid ${theme.colors.gold}`,
    },
  },
  label: {
    marginBottom: "5px",
    color: "#64748B",
    fontSize: "18px",
    fontWeight: 700,
  },
};

interface SelectFieldProps {
  label: string;
  placeholder: string;
  data: string[];
  [key: string]: any;
}

export default function CustomSelect({
  label,
  placeholder,
  data,
  ...props
}: SelectFieldProps) {
  return (
    <Select
      label={label}
      placeholder={placeholder}
      size="lg"
      rightSection={<IconChevronDown size={16} />}
      data={data}
      styles={inputStyles}
      {...props}
    />
  );
}
