import { Box, Text, Checkbox, Flex, TextInput, Button } from "@mantine/core";
import { IconVideo } from "@tabler/icons-react";
import CustomInput from "./CustomInput";
import CustomSelect from "./CustomSelect";
import theme from "@/styles/theme";

export default function StepAccessInfo({
  onNext,
  onBack,
}: {
  onNext: () => void;
  onBack: () => void;
}) {
  return (
    <Box mt="xl">
      <Text c="#8C8082" fw={700} size="xl" mb="md">
        معلومات تسجيل الدخول
      </Text>

      <TextInput
        label="معلومات تسجيل الدخول"
        placeholder="أدخل تفاصيل الدخول"
        size="lg"
        styles={{
          input: {
            borderRadius: 6,
            background: theme.colors.white,
            height: 50,
            "&:focus": {
              border: `1px solid ${theme.colors.gold}`,
            },
          },
          label: {
            marginBottom: "5px",
            color: "#64748B",
            fontSize: "18px",
            fontWeight: 700,
          },
        }}
        mt="md"
      />

      <Checkbox
        label="سيتم التواصل مع الضيف مباشرة"
        color={theme.colors.gold}
        size="md"
        mt="md"
      />
      <Checkbox
        label="اختيار وقت ظهور تعليمات الدخول للضيف"
        color={theme.colors.gold}
        size="md"
        mt="sm"
      />

      <Flex gap="md" wrap="wrap" mt="md">
        <Box style={{ flex: 1 }}>
          <CustomSelect
            label="وقت الدخول"
            placeholder="اختر الوقت"
            data={["12:00", "14:00", "16:00", "18:00"]}
          />
        </Box>
        <Box style={{ flex: 1 }}>
          <CustomSelect
            label="وقت الظهور"
            placeholder="اختر الوقت"
            data={[
              "قبل الوصول بـ 24 ساعة",
              "قبل الوصول بـ 12 ساعة",
              "عند الوصول",
            ]}
          />
        </Box>
      </Flex>

      <TextInput
        label="تعليمات صوتية لتسجيل الدخول"
        placeholder="مثال: قم بإدخال الرمز بعد سماع الصافرة"
        size="lg"
        rightSection={<IconVideo size={20} />}
        styles={{
          input: {
            borderRadius: 6,
            background: theme.colors.white,
            height: 50,
            "&:focus": {
              border: `1px solid ${theme.colors.gold}`,
            },
          },
          label: {
            marginBottom: "5px",
            color: "#64748B",
            fontSize: "18px",
            fontWeight: 700,
          },
        }}
        mt="md"
      />

      <CustomInput label="اسم الشبكة" placeholder="أدخل اسم شبكة الواي فاي" />
      <CustomInput label="كلمة المرور" placeholder="أدخل كلمة مرور الشبكة" />

      <Flex gap="md" wrap="wrap" mt="md">
        <Box style={{ flex: 1 }}>
          <CustomInput label="رمز بوابة 1" placeholder="أدخل الرمز" />
        </Box>
        <Box style={{ flex: 1 }}>
          <CustomSelect
            label="وقت الظهور"
            placeholder="اختر الوقت"
            data={[
              "عند الوصول",
              "قبل الوصول بـ 1 ساعة",
              "قبل الوصول بـ 12 ساعة",
            ]}
          />
        </Box>
      </Flex>

      <TextInput
        label="مميزات السكن"
        placeholder="أدخل المميزات"
        size="lg"
        mt="md"
        styles={{
          input: {
            borderRadius: 6,
            background: theme.colors.white,
            height: 50,
          },
        }}
      />

      <TextInput
        label="التعليمات والتحذيرات"
        placeholder="أدخل التعليمات"
        size="lg"
        mt="md"
        styles={{
          input: {
            borderRadius: 6,
            background: theme.colors.white,
            height: 50,
          },
        }}
      />

      <CustomInput label="رقم التواصل 1" placeholder="أدخل رقم التواصل" />
      <CustomInput label="رقم التواصل 2" placeholder="أدخل رقم التواصل" />

      <Flex gap="md" mt="xl" justify="center">
        <Button
          radius="md"
          size="lg"
          w="50%"
          onClick={onNext}
          style={{
            backgroundColor: "#8C8082",
            color: "white",
          }}
        >
          التالي
        </Button>
        <Button
          radius="md"
          w="50%"
          size="lg"
          onClick={onBack}
          variant="outline"
          style={{
            backgroundColor: "#FFF",
            border: "1px solid #E2E8F0",
            color: "#64748B",
          }}
        >
          رجوع
        </Button>
      </Flex>
    </Box>
  );
}
