import { Box, Button, Flex, Stack, Text } from "@mantine/core";
import { FieldGroup, formFields } from "./formFields";
import styles from "../../styles.module.css";
import CustomInput from "./CustomInput";
import CustomSelect from "./CustomSelect";

interface StepProps {
  onNext: () => void;
}

const FieldGroupComponent = ({ fields, type }: FieldGroup) => (
  <Flex gap="md" wrap="wrap">
    {fields.map((field: any, index: any) => (
      <Box key={index} style={{ flex: 1 }} className={styles.FieldGroup}>
        {type === "input" ? (
          <CustomInput {...field} />
        ) : (
          <CustomSelect {...field} />
        )}
      </Box>
    ))}
  </Flex>
);

export default function StepGeneralInfo({ onNext }: StepProps) {
  return (
    <Box mt="xl">
      <Text size="xl" fw={700} mb="xl">
        معلومات عامة عن السكن
      </Text>

      <Stack gap="md">
        {formFields.generalInfo.map((group: any, index: any) => (
          <FieldGroupComponent key={index} {...group} />
        ))}

        <Text size="xl" fw={700} mt="xl" mb="xl">
          الصالات والغرف
        </Text>

        {formFields.roomsInfo.map((group: any, index: any) => (
          <FieldGroupComponent key={index} {...group} />
        ))}
      </Stack>

      <Flex gap="md" mt="xl" justify="center">
        <Button
          radius="md"
          size="lg"
          w="50%"
          onClick={onNext}
          style={{
            backgroundColor: "#8C8082",
            color: "white",
          }}
        >
          التالي
        </Button>
      </Flex>
    </Box>
  );
}
