// components/steps/StepPricing.tsx
import { Box, Button, Chip, Flex, Group, Stack, Text } from "@mantine/core";
import CustomInput from "./CustomInput";
import CustomSelect from "./CustomSelect";
import theme from "@/styles/theme";

interface StepProps {
  onNext: () => void;
  onBack: () => void;
}

export default function StepPricing({ onNext, onBack }: StepProps) {
  return (
    <Box mt="xl">
      <Text c="#8C8082" fw={700} size="xl" mb="md">
        السعر
      </Text>

      {[...Array(3)].map((_, i) => (
        <Flex key={i} gap="md" wrap="wrap" mb="md">
          <Box style={{ flex: 1 }}>
            <CustomInput label="اليوم" placeholder="أدخل اليوم" />
          </Box>
          <Box style={{ flex: 1 }}>
            <CustomInput label="السعر" placeholder="أدخل السعر" />
          </Box>
        </Flex>
      ))}

      <Text c="#8C8082" fw={700} size="xl" mb="md" mt="xl">
        المناسبات
      </Text>

      {[...Array(3)].map((_, i) => (
        <Flex key={i} gap="md" wrap="wrap" mb="md">
          <Box style={{ flex: 1 }}>
            <CustomInput label="المناسبة" placeholder="أدخل المناسبة" />
          </Box>
          <Box style={{ flex: 1 }}>
            <CustomInput label="السعر" placeholder="أدخل السعر" />
          </Box>
        </Flex>
      ))}

      <Text c="#8C8082" fw={700} size="xl" mb="md" mt="xl">
        العربون
      </Text>

      <Group>
        <Chip value="accept" variant="outline" color="gold" radius="md">
          قبول العربون
        </Chip>
        <Chip value="reject" variant="outline" color="gold" radius="md">
          رفض العربون
        </Chip>
      </Group>

      <Box mt="md" mb="xl">
        <CustomSelect
          label="العربون"
          placeholder="نسبة العربون"
          data={["10%", "20%", "30%", "50%"]}
        />
      </Box>

      <Text c="#8C8082" fw={700} size="xl" mb="md" mt="xl">
        الخصومات
      </Text>

      <CustomSelect
        label="الخصم"
        placeholder="نوع الخصم"
        data={["نقدي", "موسمي", "رمزي"]}
      />

      <Flex gap="md" wrap="wrap" mt="md" mb="xl">
        <Box style={{ flex: 1 }}>
          <CustomInput label="النسبة" placeholder="أدخل النسبة" />
        </Box>
        <Box style={{ flex: 1 }}>
          <CustomInput label="القيمة" placeholder="أدخل القيمة" />
        </Box>
      </Flex>

      <Text c="#8C8082" fw={700} size="xl" mb="md" mt="xl">
        إعدادات الدخول المبكر والخروج المتأخر
      </Text>

      <Flex justify="space-between" align="center" mb="lg">
        <Text>الدخول المبكر</Text>
        <Chip color={theme.colors.gold} variant="filled" size="md">
          مفعل
        </Chip>
      </Flex>

      <Flex justify="space-between" align="center" mb="xl">
        <Text>الخروج المتأخر</Text>
        <Chip color={theme.colors.gold} variant="filled" size="md">
          مفعل
        </Chip>
      </Flex>

      <Text c="#8C8082" fw={700} size="xl" mb="md" mt="xl">
        الحد الأدنى لعدد الليالي
      </Text>

      <CustomSelect
        label="الحد الادني لعدد الليالي"
        placeholder="اختر العدد"
        data={["1", "2", "3", "4", "5", "6", "7", "10", "14"]}
      />

      <Flex gap="md" mt="xl" justify="center">
        <Button
          radius="md"
          size="lg"
          w="50%"
          onClick={onNext}
          style={{
            backgroundColor: "#8C8082",
            color: "white",
          }}
        >
          التالي
        </Button>
        <Button
          radius="md"
          size="lg"
          w="50%"
          onClick={onBack}
          variant="outline"
          style={{
            backgroundColor: "#FFF",
            border: "1px solid #E2E8F0",
            color: "#64748B",
          }}
        >
          رجوع
        </Button>
      </Flex>
    </Box>
  );
}
