import { ReactNode } from "react";
import { IconMapPin } from "@tabler/icons-react";

export interface InputField {
  label: string;
  placeholder: string;
  rightSection?: ReactNode;
}

export interface SelectField extends InputField {
  data: string[];
}

export interface FieldGroup {
  type: "input" | "select";
  fields: (InputField | SelectField)[];
}

const iconMapPin = <IconMapPin size={16} />;

export const formFields = {
  generalInfo: [
    {
      type: "input",
      fields: [
        { label: "عدد المساكن", placeholder: "أدخل عدد المساكن" },
        { label: "رمز السكن", placeholder: "أدخل رمز السكن" },
      ],
    },
    {
      type: "input",
      fields: [
        { label: "اسم السكن في العرض", placeholder: "أدخل اسم السكن" },
        { label: "اسم السكن المختصر", placeholder: "أدخل الاسم المختصر" },
      ],
    },
    {
      type: "input",
      fields: [
        { label: "مساحة المسكن", placeholder: "أدخل المساحة" },
        { label: "المدينة", placeholder: "أدخل المدينة" },
      ],
    },
    {
      type: "input",
      fields: [
        { label: "المنطقة", placeholder: "أدخل المنطقة" },
        { label: "الحي", placeholder: "أدخل الحي" },
        { label: "الشارع", placeholder: "أدخل الشارع" },
      ],
    },
    {
      type: "input",
      fields: [
        {
          label: "خرائط جوجل",
          placeholder: "أدخل الموقع",
          rightSection: iconMapPin,
        },
      ],
    },
    {
      type: "input",
      fields: [
        { label: "وقت تسجيل الدخول", placeholder: "أدخل وقت الدخول" },
        { label: "وقت تسجيل الخروج", placeholder: "أدخل وقت الخروج" },
      ],
    },
  ],
  roomsInfo: [
    {
      type: "input",
      fields: [
        { label: "عدد الأسرة 1", placeholder: "أدخل العدد" },
        { label: "عدد الأسرة 2", placeholder: "أدخل العدد" },
        { label: "عدد الأسرة 3", placeholder: "أدخل العدد" },
      ],
    },
    {
      type: "select",
      fields: [
        {
          label: "عدد الصالات",
          placeholder: "اختر العدد",
          data: ["1", "2", "3", "4", "5"],
        },
        {
          label: "عدد الغرف",
          placeholder: "اختر العدد",
          data: ["1", "2", "3", "4", "5", "6", "7", "8"],
        },
      ],
    },
    {
      type: "select",
      fields: [
        {
          label: "عدد المطابخ",
          placeholder: "اختر العدد",
          data: ["1", "2", "3"],
        },
        {
          label: "عدد دورات المياه",
          placeholder: "اختر العدد",
          data: ["1", "2", "3", "4", "5"],
        },
      ],
    },
    {
      type: "select",
      fields: [
        {
          label: "جلسة الطعام",
          placeholder: "اختر العدد",
          data: ["1", "2", "3"],
        },
        {
          label: "عدد الكراسي",
          placeholder: "اختر العدد",
          data: ["2", "4", "6", "8", "10"],
        },
      ],
    },
    {
      type: "select",
      fields: [
        {
          label: "الحد الأقصى للضيوف",
          placeholder: "اختر العدد",
          data: ["2", "4", "6", "8", "10", "12", "14", "16"],
        },
        {
          label: "الحد الأقصى لعدد الليالي",
          placeholder: "اختر العدد",
          data: ["1", "2", "3", "4", "5", "6", "7", "14", "30"],
        },
      ],
    },
  ],
};
