import "@mantine/core/styles.css";
import "@mantine/charts/styles.css";
import "./globals.css";

import { ColorSchemeScript, mantineHtmlProps } from "@mantine/core";
import RootLayoutClient from "./RootLayoutClient";

export const metadata = {
  title: "Katton Project",
  description: "Katton Bookings System",
  icons: {
    icon: "/images/logo.png",
    apple: "/images/logo.png",
  },
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="ar" dir="rtl" {...mantineHtmlProps}>
      <head>
        <ColorSchemeScript
          forceColorScheme="light"
          defaultColorScheme="light"
        />
      </head>
      <body style={{ backgroundColor: "#F8FAFC" }}>
        <RootLayoutClient>{children}</RootLayoutClient>
      </body>
    </html>
  );
}
