"use client";
import { Dialog, Flex, Text } from "@mantine/core";
import { IconX } from "@tabler/icons-react";

export function ErrorDialog({
  opened,
  onClose,
  message,
}: {
  opened: boolean;
  onClose: () => void;
  message: string;
}) {
  return (
    <Dialog
      opened={opened}
      onClose={onClose}
      title="خطأ"
      position={{ bottom: 20, left: 20 }}
    >
      <Flex align="center" justify="space-between">
        <IconX
          color="white"
          style={{
            backgroundColor: "#fa5252",
            borderRadius: "50%",
            padding: 2,
          }}
        />
        <Text c="red">{message}</Text>
      </Flex>
    </Dialog>
  );
}
