import theme from "@/styles/theme";
import { Modal, Box, Text, Button, Group } from "@mantine/core";
import { IconX } from "@tabler/icons-react";

interface ErrorModalProps {
  opened: boolean;
  onClose: () => void;
}

export function ErrorModal({ opened, onClose }: ErrorModalProps) {
  return (
    <Modal
      opened={opened}
      onClose={onClose}
      centered
      padding="xl"
      styles={{
        content: {
          borderRadius: "20px",
          background: "#FFF",
          boxShadow: "8px 8px 108px 0px rgba(0, 0, 0, 0.05)",
        },
      }}
    >
      <Box ta="center">
        <Box
          style={{
            width: "80px",
            height: "80px",
            borderRadius: "50%",
            background: "#E60F0F",
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
            margin: "0 auto 30px",
          }}
        >
          <IconX size={40} color={theme.colors.white} />
        </Box>

        <Text size="xl" fw={700} mb={8}>
          خطأ
        </Text>

        <Text c="dimmed" mb={24}>
          هذا التصريح مستخدم او غير صحيح
        </Text>

        <Button
          fullWidth
          radius="md"
          style={{
            backgroundColor: "#E60F0F",
            color: "white",
          }}
          onClick={onClose}
        >
          اعادة رفع التصريح
        </Button>
      </Box>
    </Modal>
  );
}
