"use client";
import { Dialog, Flex, Text } from "@mantine/core";
import { IconCheck } from "@tabler/icons-react";

export function SuccessDialog({
  opened,
  onClose,
  message,
}: {
  opened: boolean;
  onClose: () => void;
  message: string;
}) {
  return (
    <Dialog
      opened={opened}
      onClose={onClose}
      title="نجاح"
      position={{ bottom: 20, left: 20 }}
    >
      <Flex align="center" justify="space-between">
        <IconCheck
          color="white"
          style={{
            backgroundColor: "#2b8a3e",
            borderRadius: "50%",
            padding: 2,
          }}
        />
        <Text c="green">{message}</Text>
      </Flex>
    </Dialog>
  );
}
